#ifndef _ARROW_H
#define _ARROW_H

#include <QtGui>

class Table;

class Arrow : public QGraphicsLineItem
{
	public:
		Arrow(QGraphicsItem * parent = 0);
		Arrow(Table* startTable, Table* endTable, int mode, QGraphicsItem *parent = 0);
		virtual ~Arrow();
		
	public:
		QRectF boundingRect() const;
		QPainterPath shape() const;
		
		bool operator ==(Arrow* other);

	public slots:
		void updatePosition();

	protected:
		void paint(QPainter * painter, const QStyleOptionGraphicsItem * option, QWidget * widget = 0);
		void mouseDoubleClickEvent ( QGraphicsSceneMouseEvent * event );
			
	public:
		Table* GetStartTable() const;
		Table* GetEndTable() const;
		QPolygonF GetHead() const;
		int GetMode();
		void SetCardinality(int endTableCardinality);
		void DrawCardinality(QPainter *painter, QPointF& intersectPoint, QPointF& startTableCenterPoint, QLineF& centerLine);
		int GetEndTableCardinality() const;

		QGraphicsTextItem* GetStartCardinality() const;
		QGraphicsTextItem* GetEndCardinality() const;

		void SetPosCardi();

	private:
		Table* startTable;
		Table* endTable;

		int startTableCardinality;		// 1:1, 2:0, 3:
		int endTableCardinality;		// 1:"0-", 2:"1-", 3:"0-1"
		
		QString startCardi;
		QString endCardi;
		
		QPointF startCardinalityPoint;
		QPointF endCardinalityPoint;

		QGraphicsTextItem* startCardinality;
		QGraphicsTextItem* endCardinality;

		QPolygonF head;
		int mode;  // 1.Line1, 2.Line2, 3.Line3
};

inline Table* Arrow::GetStartTable() const
{
	return this->startTable;
}

inline Table* Arrow::GetEndTable() const
{
	return this->endTable;
}

inline QPolygonF Arrow::GetHead() const
{
	return this->head;
}

inline int Arrow::GetMode()
{
	return this->mode;
}

inline int Arrow::GetEndTableCardinality() const
{
	return this->endTableCardinality;
}

inline QGraphicsTextItem* Arrow::GetStartCardinality() const
{
	return this->startCardinality;
}

inline QGraphicsTextItem* Arrow::GetEndCardinality() const
{
	return this->endCardinality;
}

#endif //_ARROW_H

